<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Albúm</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>



    <?php
    $imagenesEspana = glob("España/*.{jpg,jpeg,png,gif}", GLOB_BRACE);
    $imagenesRumania = glob("Rumania/*.{jpg,jpeg,png,gif}", GLOB_BRACE);
    $imagenesColombia = glob("Colombia/*.{jpg,jpeg,png,gif}", GLOB_BRACE);
    $albumes = [
        'colombia' => $imagenesColombia,
        'rumania'  => $imagenesRumania,
        'espana'   => $imagenesEspana
    ];
    $albumSeleccionado = isset($_GET['album']) ? $_GET['album'] : '';
    $posicion = isset($_GET['pos']) ? (int)$_GET['pos'] : 0;

    ?>
    <header>
        <div>
            <h1>Albúm de fotos</h1>
        </div>
        <div>
            <ul>
                <li><a href="?album=espana">España</a></li>
                <li><a href="?album=rumania">Rumania</a></li>
                <li><a href="?album=colombia">Colombia</a></li>

            </ul>
        </div>


    </header>

    <main>
        <div id="imagen">
            <?php
            if (isset($albumes[$albumSeleccionado])) {

                if ($posicion < 0) $posicion = 0;
                if ($posicion >= count($albumes[$albumSeleccionado])) $posicion = count($albumes[$albumSeleccionado]) - 1; 

                echo "<img src='" . $albumes[$albumSeleccionado][$posicion] . "' alt='Foto'>";
            } else {
                echo "<p>Selecciona un álbum para visualizar</p>";
            }
            ?>
        </div>
        <div>
            <?php
            if (isset($albumes[$albumSeleccionado])) {
                $total = count($albumes[$albumSeleccionado]);
                $siguiente = ($posicion + 1) % $total;
                $anterior  = ($posicion - 1 + $total) % $total;

                echo "<a href='?album=$albumSeleccionado&pos=$anterior'>Anterior</a>";
                echo "<a href='?album=$albumSeleccionado&pos=$siguiente'>Siguiente</a>";
            } 

            if ((isset($albumes[$albumSeleccionado]))!=0){
                echo "<a href='?albumes[0][0]'>Resetear</a>";

            }


            ?>
        </div>


    </main>



</body>

</html>